/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.backend.service.impl;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import ru.easydata.scheduler.backend.components.remote.RemoteLauncher;
import ru.easydata.scheduler.backend.components.remote.RemoteRuntime;
import ru.easydata.scheduler.backend.dto.ServerDto;
import ru.easydata.scheduler.backend.dto.SystemInfoDto;
import ru.easydata.scheduler.backend.entities.ServerEntity;
import ru.easydata.scheduler.backend.exception.SchedulerException;
import ru.easydata.scheduler.backend.mappers.ServerMapper;
import ru.easydata.scheduler.backend.repositoryes.ServerRepository;
import ru.easydata.scheduler.backend.service.DistService;
import ru.easydata.scheduler.backend.service.ServerService;
import ru.easydata.scheduler.backend.service.impl.ServerImpl;

@Service(value="serverService")
@Lazy
@Validated
public class ServerImpl
implements ServerService,
GroovyObject {
    @Autowired
    protected ServerRepository serverRepository;
    @Autowired
    protected ServerMapper serverMapper;
    @Autowired
    protected ThreadPoolTaskExecutor threadExecutor;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected RemoteLauncher remoteLauncher;
    @Autowired
    protected RemoteRuntime remoteRuntime;
    @Autowired
    protected DistService distService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ServerImpl() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<ServerDto> list() {
        CallSite serverEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.serverRepository, IndyInterface.bootstrap("invoke", "by", 0, Sort.class, IndyInterface.bootstrap("getProperty", "ASC", 0, Sort.Direction.class), "title")));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, serverEntities), new _list_closure1((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public List<ServerDto> options() {
        CallSite serverEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAllOptions", 0, this.serverRepository));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "stream", 0, serverEntities), new _options_closure2((Object)this, (Object)this)), IndyInterface.bootstrap("invoke", "toList", 0, Collectors.class)));
    }

    public void sendListSystemInfo() {
        CallSite serverEntities = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.serverRepository));
        IndyInterface.bootstrap("invoke", "forEach", 0, serverEntities, new _sendListSystemInfo_closure3((Object)this, (Object)this));
    }

    public ServerDto get(Integer serverId) throws SchedulerException {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.serverMapper, serverEntity));
    }

    public SystemInfoDto systemInfo(Integer serverId) {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        CallSite systemInfoDto = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SystemInfoDto.class, IndyInterface.bootstrap("invoke", "systemInfo", 0, this.remoteRuntime, serverEntity)));
        CallSite runtimeVersion = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "version", 0, this.remoteRuntime, serverEntity));
        CallSite launcherVersion = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "version", 0, this.remoteLauncher, serverEntity));
        GStringImpl gStringImpl = new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "version", 0, runtimeVersion), IndyInterface.bootstrap("getProperty", "versionDate", 0, runtimeVersion)}, new String[]{"", " (", ")"});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, ServerImpl.class, (GroovyObject)systemInfoDto, (String)"runtimeVersion");
        CallSite callSite = IndyInterface.bootstrap("invoke", "startDate", 0, this.remoteRuntime, serverEntity);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, ServerImpl.class, (GroovyObject)systemInfoDto, (String)"runtimeStart");
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "version", 0, launcherVersion), IndyInterface.bootstrap("getProperty", "versionDate", 0, launcherVersion)}, new String[]{"", " (", ")"});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl2, ServerImpl.class, (GroovyObject)systemInfoDto, (String)"launcherVersion");
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "startDate", 0, this.remoteLauncher, serverEntity);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, ServerImpl.class, (GroovyObject)systemInfoDto, (String)"launcherStart");
        CallSite callSite3 = systemInfoDto;
        try {
            return callSite3;
        }
        catch (Exception e) {
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, IndyInterface.bootstrap("getProperty", "message", 0, e)) : null;
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SystemInfoDto.class));
    }

    public ServerDto create(ServerDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            ServerDto serverDto = dto;
            valueRecorder.record((Object)serverDto, 9);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, serverDto);
            valueRecorder.record((Object)callSite, 13);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.serverMapper, dto));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.serverMapper, IndyInterface.bootstrap("invoke", "save", 0, this.serverRepository, serverEntity)));
        try {
            return callSite;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    public ServerDto update(Integer id, ServerDto dto) throws SchedulerException {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            ServerDto serverDto = dto;
            valueRecorder.record((Object)serverDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, serverDto);
            valueRecorder.record((Object)callSite, 12);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            ServerDto serverDto = dto;
            valueRecorder2.record((Object)serverDto, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 4, serverDto);
            valueRecorder2.record((Object)callSite, 12);
            Integer n = id;
            valueRecorder2.record((Object)n, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder2.record((Object)bl, 15);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert dto.id == id", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        IndyInterface.bootstrap("invoke", "clearCacheHttpClient", 0, this.remoteLauncher);
        IndyInterface.bootstrap("invoke", "clearCacheHttpClient", 0, this.remoteRuntime);
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.serverMapper, dto));
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = serverEntity;
            valueRecorder3.record((Object)callSite, 9);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "isGroup", 4, callSite);
            valueRecorder3.record((Object)callSite2, 22);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite2) == false;
            valueRecorder3.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !serverEntity.isGroup", (ValueRecorder)valueRecorder3), null);
            }
            valueRecorder3.clear();
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "map", 0, this.serverMapper, IndyInterface.bootstrap("invoke", "save", 0, this.serverRepository, serverEntity)));
        try {
            return callSite;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    public boolean delete(Integer id) throws SchedulerException {
        IndyInterface.bootstrap("invoke", "deleteById", 0, this.serverRepository, id);
        boolean bl = true;
        try {
            return bl;
        }
        catch (DataIntegrityViolationException e) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "message", 0, e), "WORKFLOW_SERVER_SERVER_ID_FK")) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440, \u0435\u0441\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u043d\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u044b"));
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    public boolean start(Integer serverId) throws SchedulerException {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        try {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "runtimeIsRun", 0, this.remoteLauncher, serverEntity)) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity)}, new String[]{"\u0420\u0430\u043d\u0442\u0430\u0439\u043c ", " \u0443\u0436\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d"})));
            }
            IndyInterface.bootstrap("invoke", "runtimeStart", 0, this.remoteLauncher, serverEntity, IndyInterface.bootstrap("invoke", "runtimeLastVersionFileName", 0, this.distService));
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0440\u0430\u043d\u0442\u0430\u0439\u043c ", ": ", ""}), e));
        }
        return true;
    }

    public boolean upgrade(Integer serverId) throws SchedulerException {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        try {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "runtimeIsRun", 0, this.remoteLauncher, serverEntity)) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity)}, new String[]{"\u0420\u0430\u043d\u0442\u0430\u0439\u043c ", " \u0443\u0436\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d"})));
            }
            IndyInterface.bootstrap("invoke", "runtimeUpdate", 0, this.remoteLauncher, serverEntity, IndyInterface.bootstrap("invoke", "runtimeLastVersionFileName", 0, this.distService));
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0430\u043d\u0442\u0430\u0439\u043c ", ": ", ""}), e));
        }
        return true;
    }

    public boolean stop(Integer serverId) throws SchedulerException {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        try {
            CallSite executorListSize = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "executorListSize", 0, this.remoteRuntime, serverEntity));
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)executorListSize, (Object)0)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity), executorListSize}, new String[]{"\u041d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 ", " \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e ", " \u0437\u0430\u0434\u0430\u0447"})));
            }
            IndyInterface.bootstrap("invoke", "runtimeStop", 0, this.remoteLauncher, serverEntity);
        }
        catch (Exception e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "title", 4, serverEntity), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0430\u043d\u0442\u0430\u0439\u043c ", ": ", ""}), e));
        }
        return true;
    }

    public boolean enable(Integer serverId) throws SchedulerException {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "setActive", 2, this, serverId, true));
    }

    public boolean disable(Integer serverId) throws SchedulerException {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "setActive", 2, this, serverId, false));
    }

    public void onRuntimeStart() {
        IndyInterface.bootstrap("invoke", "sendListSystemInfo", 2, this);
    }

    public void onRuntimeStop() {
        IndyInterface.bootstrap("invoke", "sendListSystemInfo", 2, this);
    }

    protected boolean setActive(Integer serverId, boolean isActive) throws SchedulerException {
        CallSite serverEntity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findServerEntity", 2, this, serverId));
        boolean bl = isActive;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, ServerImpl.class, (GroovyObject)serverEntity, (String)"isActive");
        IndyInterface.bootstrap("invoke", "save", 0, this.serverRepository, serverEntity);
        boolean bl2 = true;
        try {
            return bl2;
        }
        catch (DataIntegrityViolationException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, SchedulerException.class, IndyInterface.bootstrap("getProperty", "message", 0, e)));
        }
    }

    protected ServerEntity findServerEntity(Integer serverId) throws SchedulerException {
        Reference serverId2 = new Reference((Object)serverId);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElseThrow", 0, IndyInterface.bootstrap("invoke", "findById", 0, this.serverRepository, (Integer)serverId2.get()), new _findServerEntity_closure4((Object)this, (Object)this, serverId2)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ServerImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.backend.service.impl.ServerImpl");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

