/*
 * Decompiled with CFR 0.152.
 */
package ru.easydata.scheduler.runtime.components;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;
import ru.easydata.scheduler.runtime.config.AppProperties;
import ru.easydata.scheduler.runtime.entities.SystemStatisticEntity;
import ru.easydata.scheduler.runtime.repositoryes.SystemStatisticRepository;

@Component
public class SystemStatisticThread
implements Runnable,
GroovyObject {
    @Autowired
    private SystemStatisticRepository systemStatisticRepository;
    @Autowired
    private AppProperties appProperties;
    private final AtomicBoolean stopping;
    private Thread worker;
    private long[] oldTicks;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public SystemStatisticThread() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, AtomicBoolean.class, false);
        this.stopping = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void start() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Thread thread = this.worker;
            valueRecorder.record((Object)thread, 13);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)thread, null);
            valueRecorder.record((Object)bl, 20);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert this.worker == null", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Thread.class, this);
        this.worker = IndyInterface.bootstrap("cast", "()", 0, callSite);
        IndyInterface.bootstrap("invoke", "start", 0, this.worker);
    }

    public boolean isRun() {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "alive", 0, this.worker));
    }

    public void stop() {
        IndyInterface.bootstrap("invoke", "set", 0, this.stopping, true);
        Object var1_1 = null;
        this.worker = IndyInterface.bootstrap("cast", "()", 0, var1_1);
    }

    @Override
    public void run() {
        IndyInterface.bootstrap("invoke", "info", 0, log, "\u0417\u0430\u043f\u0443\u0441\u043a \u0441\u0431\u043e\u0440\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
        CallSite si = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SystemInfo.class));
        CallSite hal = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHardware", 0, si));
        CallSite cpu = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getProcessor", 0, hal));
        CallSite callSite = IndyInterface.bootstrap("invoke", "getSystemCpuLoadTicks", 0, cpu);
        this.oldTicks = (long[])IndyInterface.bootstrap("cast", "()", 0, callSite);
        while (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.stopping)) == false) {
            IndyInterface.bootstrap("invoke", "sleep", 2, this, IndyInterface.bootstrap("invoke", "multiply", 0, 1000, IndyInterface.bootstrap("getProperty", "interval", 0, IndyInterface.bootstrap("getProperty", "statistic", 0, this.appProperties))));
            CallSite ss = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "save", 0, this.systemStatisticRepository, IndyInterface.bootstrap("init", "<init>", 0, SystemStatisticEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"interspace", IndyInterface.bootstrap("getProperty", "interval", 0, IndyInterface.bootstrap("getProperty", "statistic", 0, this.appProperties)), "memUsedPercent", IndyInterface.bootstrap("invoke", "getMemPerc", 2, this, hal), "cpuUsedPercent", IndyInterface.bootstrap("invoke", "getCpuPerc", 2, this, cpu)}))));
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{ss}, new String[]{"\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u0431\u0430\u0437\u0443 \u0434\u0430\u043d\u043d\u044b\u0445: ", ""})) : null;
        }
        IndyInterface.bootstrap("invoke", "info", 0, log, "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0431\u043e\u0440\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438");
    }

    private double getCpuPerc(CentralProcessor cpu) {
        double cpuPerc = DefaultTypeTransformation.doubleUnbox((Object)IndyInterface.bootstrap("invoke", "getSystemCpuLoadBetweenTicks", 0, cpu, this.oldTicks));
        CallSite callSite = IndyInterface.bootstrap("invoke", "getSystemCpuLoadTicks", 0, cpu);
        this.oldTicks = (long[])IndyInterface.bootstrap("cast", "()", 0, callSite);
        return DefaultTypeTransformation.doubleUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, cpuPerc, 100));
    }

    private double getMemPerc(HardwareAbstractionLayer hal) {
        CallSite globalMemory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMemory", 0, hal));
        long available = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "getAvailable", 0, globalMemory));
        long total = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "getTotal", 0, globalMemory));
        return DefaultTypeTransformation.doubleUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("invoke", "minus", 0, total, available), total), 100));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SystemStatisticThread.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "ru.easydata.scheduler.runtime.components.SystemStatisticThread");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

